document.getElementById('play').addEventListener('click', () => {
  username1 = document.getElementById('username').value.toLowerCase();
  city2 = document.getElementById('city').value.toLowerCase();
  country1 = document.getElementById('country').value.toLowerCase();
  chrome.tabs.reload();
  chrome.runtime.sendMessage({type: "input", username1, city2, country1 });
});

document.getElementById('linkedin').addEventListener('click', async () => {
 granted = await chrome.permissions.request({origins: ["https://*.linkedin.com/"]});
  if (granted) document.getElementById('linkedin').style.backgroundColor = "white";
});
document.getElementById('facebook').addEventListener('click', async () => {
 granted = await chrome.permissions.request({origins: ["https://*.facebook.com/"]});
  if (granted) document.getElementById('facebook').style.backgroundColor = "white";
});
document.getElementById('instagram').addEventListener('click', async () => {
 granted = await chrome.permissions.request({origins: ["https://*.instagram.com/"]});
  if (granted) document.getElementById('instagram').style.backgroundColor = "white";
});
document.getElementById('all').addEventListener('click', async () => {
 granted = await chrome.permissions.request({origins: ["<all_urls>"]});
  if (granted) document.querySelectorAll('.box').forEach(box => {box.style.backgroundColor = "white";});
});

document.getElementById('pause').addEventListener('click', () => {
  chrome.runtime.sendMessage({ type: "pause" });
});

i = 0;
countries = ["United States","United Kingdom"];
document.getElementById("country").addEventListener('click', () => {
document.getElementById("country").value = countries[i]; i++;
if (i == countries.length) i = 0;
});

chrome.runtime.onMessage.addListener(async function (msg) {
  if (msg.update){
    div = document.getElementById("updates");
    ps = div.querySelectorAll("p");
    if (ps.length > 3) ps[0].remove();
    p = document.createElement("p");
    content =  msg.update.slice(0, 35) + " &#9993;";
    if (msg.phone) content += " &#128222;";
    p.innerHTML = content;
    div.appendChild(p);
  }

  if (msg.checked) document.getElementById("results").innerHTML = "Found: "+ msg.found +"&nbsp;&nbsp;&bull;&nbsp;&nbsp;Checked: "+ msg.checked;

  await chrome.storage.session.set({
    resultsHTML: document.getElementById("results").innerHTML,
    updatesHTML: document.getElementById("updates").innerHTML,
    username1: document.getElementById("username").value,
    city2: document.getElementById("city").value,
    country1: document.getElementById("country").value,
  });

});


document.addEventListener("DOMContentLoaded", async () => {
  const s = await chrome.storage.session.get(["resultsHTML","updatesHTML","username1","city2","country1"]);
  if (s.resultsHTML) document.getElementById("results").innerHTML = s.resultsHTML;
  if (s.updatesHTML) document.getElementById("updates").innerHTML = s.updatesHTML;
  if (s.username1) document.getElementById("username").value = s.username1;
  if (s.city2) document.getElementById("city").value = s.city2;
  if (s.country1) document.getElementById("country").value = s.country1;
});