dones = new Set();

async function business() {
	try {
		bags = [];
		if (["linkedin","search","people"].every(t => location.href.includes(t))) await linkedin();
		else if (["facebook","search","people"].every(t => location.href.includes(t))) await facebook();
		else if (["instagram","followers"].every(t => location.href.includes(t))) await instagram();
		//else if (location.href.includes("team") || location.href.includes("people")) await teams();
	} catch (e) {console.log(e);}
}

new MutationObserver(() => {
  clearTimeout(this.t);
  this.t = setTimeout(business, 500);
}).observe(document.body, { childList: true, subtree: true });


async function linkedin() {     	
	bads1 = "reset,show results,cancel,connect,follow,connections filter,message,previous".split(",")
	bads2 = "notifications,my network,messaging,retry premium,filter results,filter by,status is,all filters,unlimited search,upgrading to premium".split(",")
	bads3 = "network updates,notifications,retry premium,filter results,filter by,connections filter,don’t want to see this,your feedback,annoying,help us improve,search | linkedin,report this ad,help center,ad preferences,jump menu,keyboard shortcuts,your settings,learn more".split(",")

	for (div of document.querySelectorAll('*')) {
		bag = []
		for (element of div.querySelectorAll('*')) {
			text = element.textContent.toLowerCase();
			if (element.children.length > 0 && !text.startsWith('current: ') && !text.startsWith('past: ')) continue;
			text = text.replace(/\s+/g, ' ').trim();
			if (bads3.some(term => text.includes(term))) break;	
			if (text.length < 5) continue;
			if (!/^[a-z]/.test(text)) continue;
			if (bads1.includes(text)) continue;
			if (bads2.some(term => text.includes(term))) continue;
			if (text.startsWith("view ")) continue;
			bag.push(text)
			}
			if (bag.length > 2 && bag.length < 10) bags.push(bag)
		}

	for (bag of bags){
		name1 = bag[0]; job1 = bag[1]; city1 = bag[2];
		if (name1 == job1) continue;
		if ([":", "linkedin", "upgrade ", "inmail "].some(term => name1.includes(term))) continue;		
		if (name1.length > 30) continue;

		job2 = bag.find(item => item.startsWith("current: ")) ?? "";
		job2 = job2.replace("current: ", "");
		job3 = bag.find(item => item.startsWith("past: ")) ?? "";
		job3 = job3.replace("past: ", "");
		profile = name1+job1;
		if (dones.has(profile)) continue;
		dones.add(profile);
		domain = "";
		await new Promise(resolve => chrome.runtime.sendMessage({ type: "bag", name1, city1, job1, job2, job3, domain }, resolve));
	}

}


async function facebook(){
	bads1 = "reset,events,more options,search results,filters,ads manager,ads central,video,saved,people,reels,marketplace,pages,groups,add friend,active,following,follow,verified account,view profile,new posts".split(",");
	bads2 = "unread chats,unread notifications,your chats,online status,mutual friend,create".split(",");
	for (div of document.querySelectorAll('div')) {
		bag = []
		for (element of div.querySelectorAll('*')) {
			text = element.textContent.toLowerCase();
			t = element.tagName	
			if (element.children.length == 0 || t == "A"){
				if (text.length < 5) continue;
				if (text.length > 150) continue;
				if (bads1.includes(text)) continue;
				if (bads2.some(term => text.includes(term))) continue;		
				bag.push(text)
			}
		}
		if (bag.length < 2 || bag.length > 5) continue
		bagText = JSON.stringify(bag)
		if (dones.has(bagText)) continue
		dones.add(bagText);
		name1 = bag[0];
		name1 = name1.replace("verified account", "");
		info = bag[1].split(" · ");
		job1 = info.find(s => s.includes(" at ")) ?? "";
		city1 = info.find(s => s.includes("lives in")) ?? "";
		city1 = city1.replace("lives in", "");
		job2 = job3 = domain = "";
		await new Promise(resolve => chrome.runtime.sendMessage({ type: "bag", name1, city1, job1, job2, job3, domain }, resolve));
	}
}


async function instagram(){
	bads1 = "verified,follow,search,followers,settings,more,new post,create,notifications,messages,reels,carousel,clip,tagged,similar accounts,options,link icon,explore,home,instagram,profile".split(",");
	bads2 = "from meta,chevron".split(",");

	for (div of document.querySelectorAll('div')) {
		bag = []
		for (element of div.querySelectorAll('*')) {
			text = element.textContent.toLowerCase();
			if (element.children.length != 0) continue;
			if (bads1.includes(text)) continue;
			if (bads2.some(term => text.includes(term))) continue;
			if (text == "") continue;
			bag.push(text)
		}
		if (bag.length !=2 ) continue
		name1 = bag[1]
		if (name1.split(" ").length != 2) continue;
		if (!/^[a-z\s]+$/.test(name1)) continue;
		if (dones.has(name1)) continue
		dones.add(name1);
		city1 = job1 = job2 = job3 = domain = "";
		await new Promise(resolve => chrome.runtime.sendMessage({ type: "bag", name1, city1, job1, job2, job3, domain }, resolve));
	}
}

